# -*- coding: utf-8 -*-

"""
Helpers for Avizo modules and interfaces
"""

import sys
import os
import re
import struct
import numpy as np
import _hx_core 
from _hx_core import _tcl_interp, hx_project, hx_object_factory

def placeResult(computeModule, resultModule, targetPort = 0):
    """(re)place the resultModule as output of the computeModule, at the specified position.
    """
    
    previousDataset = computeModule.results[targetPort]
    
    #set result
    computeModule.results[targetPort] = resultModule
    
    if previousDataset is not None:
        previousName = previousDataset.name
        previousDataset.name = "tmp"
        previousPosition = previousDataset.icon_position
        
        #transfer connections from the previous result, to the new one
        while len(previousDataset.downstream_connections)>0:
            c = previousDataset.downstream_connections[0]
            print("connection to " + c.get_owner().name)
            c.connect( resultModule )
        
        hx_project.remove(previousDataset)
        
        print("previous name: " + previousName)
        resultModule.icon_position = previousPosition
        resultModule.name = previousName
        print("effective name: " + resultModule.name)
    
    resultModule.touch(2)
    resultModule.fire()

def getVoxelSizeFromImage(image):
    """obtain a numpy array with the voxel size of the image (assuming an HxUniformScalarField)
    """

    voxelSize = image._tcl_interp(" getVoxelSize")
    voxelSizeX = float(voxelSize.split()[0])
    voxelSizeY = float(voxelSize.split()[1])
    voxelSizeZ = float(voxelSize.split()[2])

    return np.array([voxelSizeX, voxelSizeY, voxelSizeZ])



def ArrayFromHxLandmark(hxLandmarks):
    """obtain a numpy array with the list of coordinates, from an HxLandmarks data object
    """

    nbPts = int(hxLandmarks._tcl_interp(" getNumPoints"))
    array = np.zeros((nbPts, 3))
    for n in range(nbPts):
        array_text = hxLandmarks._tcl_interp(" getPoint " + str(n))
        array[n,:] = np.array(array_text.split())
    
    return array
    
    
def HxLandmarkFromArray(arrayLdks):
    """populate an HxLandmark object from a numpy array with the list of 3D coordinates
    """
    if len(arrayLdks.shape) != 2:
        print("error in HxLandmarkFromArray: expecting a 2D array, containing a list of 3D coordinates")
        return None
    if arrayLdks.shape[1] != 3:
        print("error in HxLandmarkFromArray: expecting a 2D array, containing a list of 3D coordinates")
        return None
    
    hxLdks = hx_object_factory.create('HxLandmarkSet')
    
    for n in range(arrayLdks.shape[0]):
        hxLdks._tcl_interp(" appendLandmark " + str(arrayLdks[n,0]) + " " + str(arrayLdks[n,1]) + " " + str(arrayLdks[n,2]))

    return hxLdks
    

